/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyClass;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyMethod$instancemethod___cmp___exposer;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="instancemethod", isBaseType=false, doc="instancemethod(function, instance, class)\n\nCreate an instance method object.")
public class PyMethod
extends PyObject {
    public static final PyType TYPE;
    public PyObject im_class;
    public PyObject im_func;
    public PyObject im_self;

    public PyMethod(PyObject function, PyObject self, PyObject type) {
        super(TYPE);
        if (self == Py.None) {
            self = null;
        }
        this.im_func = function;
        this.im_self = self;
        this.im_class = type;
    }

    @ExposedNew
    static final PyObject instancemethod___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("instancemethod", args, keywords, "func");
        ap.noKeywords();
        PyObject func = ap.getPyObject(0);
        PyObject self = ap.getPyObject(1);
        PyObject classObj = ap.getPyObject(2, null);
        if (!func.isCallable()) {
            throw Py.TypeError("first argument must be callable");
        }
        if (self == Py.None && classObj == null) {
            throw Py.TypeError("unbound methods must have non-NULL im_class");
        }
        return new PyMethod(func, self, classObj);
    }

    public PyObject __findattr_ex__(String name) {
        return this.instancemethod___findattr_ex__(name);
    }

    final PyObject instancemethod___findattr_ex__(String name) {
        PyObject ret = super.__findattr_ex__(name);
        if (ret != null) {
            return ret;
        }
        return this.im_func.__findattr_ex__(name);
    }

    final PyObject instancemethod___getattribute__(PyObject arg0) {
        String name = PyMethod.asName(arg0);
        PyObject ret = this.instancemethod___findattr_ex__(name);
        if (ret == null) {
            this.noAttributeError(name);
        }
        return ret;
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        return this.instancemethod___get__(obj, type);
    }

    final PyObject instancemethod___get__(PyObject obj, PyObject type) {
        if (obj == null || this.im_self != null) {
            return this;
        }
        if (Py.isSubClass(obj.fastGetClass(), this.im_class)) {
            return new PyMethod(this.im_func, obj, this.im_class);
        }
        return this;
    }

    public PyObject __call__() {
        return this.__call__(Py.getThreadState());
    }

    public PyObject __call__(ThreadState state) {
        PyObject self = this.checkSelf(null, null);
        if (self == null) {
            return this.im_func.__call__(state);
        }
        return this.im_func.__call__(state, self);
    }

    public PyObject __call__(PyObject arg0) {
        return this.__call__(Py.getThreadState(), arg0);
    }

    public PyObject __call__(ThreadState state, PyObject arg0) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.im_func.__call__(state, arg0);
        }
        return this.im_func.__call__(state, self, arg0);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1) {
        return this.__call__(Py.getThreadState(), arg0, arg1);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.im_func.__call__(state, arg0, arg1);
        }
        return this.im_func.__call__(state, self, arg0, arg1);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.__call__(Py.getThreadState(), arg0, arg1, arg2);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.im_func.__call__(state, arg0, arg1, arg2);
        }
        return this.im_func.__call__(state, self, arg0, arg1, arg2);
    }

    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(Py.getThreadState(), arg0, arg1, arg2, arg3);
    }

    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.im_func.__call__(state, arg0, arg1, arg2, arg3);
        }
        return this.im_func.__call__(state, self, new PyObject[]{arg0, arg1, arg2, arg3}, Py.NoKeywords);
    }

    public PyObject __call__(PyObject arg1, PyObject[] args, String[] keywords) {
        return this.__call__(Py.getThreadState(), arg1, args, keywords);
    }

    public PyObject __call__(ThreadState state, PyObject arg1, PyObject[] args, String[] keywords) {
        PyObject self = this.checkSelf(arg1, args);
        if (self == null) {
            return this.im_func.__call__(state, arg1, args, keywords);
        }
        PyObject[] newArgs = new PyObject[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = arg1;
        return this.im_func.__call__(state, self, newArgs, keywords);
    }

    public PyObject __call__(PyObject[] args) {
        return this.__call__(Py.getThreadState(), args);
    }

    public PyObject __call__(ThreadState state, PyObject[] args) {
        return this.__call__(state, args, Py.NoKeywords);
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.__call__(Py.getThreadState(), args, keywords);
    }

    public PyObject __call__(ThreadState state, PyObject[] args, String[] keywords) {
        return this.instancemethod___call__(state, args, keywords);
    }

    final PyObject instancemethod___call__(ThreadState state, PyObject[] args, String[] keywords) {
        PyObject self = this.checkSelf(null, args);
        if (self == null) {
            return this.im_func.__call__(state, args, keywords);
        }
        return this.im_func.__call__(state, self, args, keywords);
    }

    private PyObject checkSelf(PyObject arg, PyObject[] args) {
        PyObject self = this.im_self;
        if (self == null) {
            if (arg != null) {
                self = arg;
            } else if (args != null && args.length >= 1) {
                self = args[0];
            }
            boolean ok = self == null ? false : Py.isInstance(self, this.im_class);
            if (!ok) {
                String msg = String.format("unbound method %s%s must be called with %s instance as first argument (got %s%s instead)", this.getFuncName(), "()", this.getClassName(this.im_class), this.getInstClassName(self), self == null ? "" : " instance");
                throw Py.TypeError(msg);
            }
            return null;
        }
        return self;
    }

    public int __cmp__(PyObject other) {
        return this.instancemethod___cmp__(other);
    }

    final int instancemethod___cmp__(PyObject other) {
        if (!(other instanceof PyMethod)) {
            return -2;
        }
        PyMethod otherMethod = (PyMethod)other;
        int cmp = this.im_func._cmp(otherMethod.im_func);
        if (cmp != 0) {
            return cmp;
        }
        if (this.im_self == otherMethod.im_self) {
            return 0;
        }
        if (this.im_self == null || otherMethod.im_self == null) {
            return System.identityHashCode(this.im_self) < System.identityHashCode(otherMethod.im_self) ? -1 : 1;
        }
        return this.im_self._cmp(otherMethod.im_self);
    }

    public int hashCode() {
        int hashCode = this.im_self == null ? Py.None.hashCode() : this.im_self.hashCode();
        return hashCode ^ this.im_func.hashCode();
    }

    public PyObject getDoc() {
        return this.im_func.__getattr__("__doc__");
    }

    public String toString() {
        String className = "?";
        if (this.im_class != null) {
            className = this.getClassName(this.im_class);
        }
        if (this.im_self == null) {
            return String.format("<unbound method %s.%s>", className, this.getFuncName());
        }
        return String.format("<bound method %s.%s of %s>", className, this.getFuncName(), this.im_self.__str__());
    }

    private String getClassName(PyObject cls) {
        if (cls instanceof PyClass) {
            return ((PyClass)cls).__name__;
        }
        if (cls instanceof PyType) {
            return ((PyType)cls).fastGetName();
        }
        return "?";
    }

    private String getInstClassName(PyObject inst) {
        if (inst == null) {
            return "nothing";
        }
        PyObject classObj = inst.__findattr__("__class__");
        if (classObj == null) {
            classObj = inst.getType();
        }
        return this.getClassName(classObj);
    }

    private String getFuncName() {
        PyObject funcName = null;
        try {
            funcName = this.im_func.__findattr__("__name__");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        if (funcName == null) {
            return "?";
        }
        return funcName.toString();
    }

    static {
        PyType.addBuilder(PyMethod.class, new PyMethod$PyExposer());
        TYPE = PyType.fromClass(PyMethod.class);
    }

    public class PyMethod$instancemethod___getattribute___exposer
    extends PyBuiltinMethodNarrow {
        public PyMethod$instancemethod___getattribute___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getattribute__('name') <==> x.name";
        }

        public PyMethod$instancemethod___getattribute___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getattribute__('name') <==> x.name";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMethod$instancemethod___getattribute___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyMethod)this.self).instancemethod___getattribute__(pyObject);
        }
    }

    public class PyMethod$instancemethod___get___exposer
    extends PyBuiltinMethodNarrow {
        public PyMethod$instancemethod___get___exposer(String string) {
            super(string, 2, 3);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyMethod$instancemethod___get___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMethod$instancemethod___get___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyMethod)this.self).instancemethod___get__(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyMethod)this.self).instancemethod___get__(pyObject, null);
        }
    }

    public class PyMethod$instancemethod___call___exposer
    extends PyBuiltinMethod {
        public PyMethod$instancemethod___call___exposer(String string) {
            super(string);
            this.doc = "x.__call__(...) <==> x(...)";
        }

        public PyMethod$instancemethod___call___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__call__(...) <==> x(...)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyMethod$instancemethod___call___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(ThreadState threadState, PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyMethod)this.self).instancemethod___call__(threadState, pyObjectArray, stringArray);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return this.__call__(Py.getThreadState(), pyObjectArray, stringArray);
        }
    }

    public class PyMethod$im_self_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$im_self_descriptor() {
            super("im_self", PyObject.class, "the instance to which a method is bound; None for unbound methods");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).im_self;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$__doc___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$__doc___descriptor() {
            super("__doc__", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).getDoc();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$im_func_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$im_func_descriptor() {
            super("im_func", PyObject.class, "the function (or other callable) implementing a method");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).im_func;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$im_class_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyMethod$im_class_descriptor() {
            super("im_class", PyObject.class, "the class associated with a method");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyMethod)pyObject).im_class;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyMethod$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyMethod.instancemethod___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyMethod$PyExposer
    extends BaseTypeBuilder {
        public PyMethod$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyMethod$instancemethod___getattribute___exposer("__getattribute__"), new PyMethod$instancemethod___get___exposer("__get__"), new PyMethod$instancemethod___call___exposer("__call__"), new PyMethod$instancemethod___cmp___exposer("__cmp__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyMethod$im_self_descriptor(), new PyMethod$__doc___descriptor(), new PyMethod$im_func_descriptor(), new PyMethod$im_class_descriptor()};
            super("instancemethod", PyMethod.class, Object.class, false, "instancemethod(function, instance, class)\n\nCreate an instance method object.", pyBuiltinMethodArray, pyDataDescrArray, new PyMethod$exposed___new__());
        }
    }
}

